"use server"

import outputs from '@/../amplify_outputs.json';
import { Schema } from '@/aws-data-schema';
import { cookies } from "next/headers";

import { generateServerClientUsingCookies } from "@aws-amplify/adapter-nextjs/api";

import { env } from '@/env';

const client = generateServerClientUsingCookies<Schema>({
  cookies: cookies,
  config: outputs
})

export async function generateFileDownloadPath(agency: string, option: 'live' | 'preview') {
  const id = INTERNAL__getBaseAgencyId(agency)
  const base = option === 'live' ? env.BACKEND_S3_DOWNLOAD_LIVE_PATH : env.BACKEND_S3_DOWNLOAD_PREVIEW_PATH
  return `${base}/${id}.gtfs.zip`
}

export async function generateFileUploadPath(agencyUploadPath: string, fileName: string) {
  const pathWithPrependedBackspace = agencyUploadPath.startsWith('/') ? agencyUploadPath : `/${agencyUploadPath}`
  return `${env.BACKEND_S3_UPLOAD_PATH}${pathWithPrependedBackspace}/${fileName}`
}

export async function triggerTripPlannerBuild(agency: string) {
  const id = INTERNAL__getBaseAgencyId(agency)
  await client.queries.startOtpDataUpdate({
    agencyid: id,
  })
  return true
};

function INTERNAL__getBaseAgencyId(agency: string) {
  const baseId = agency.split(":")[1]
  if (!baseId) {
    throw new Error(`Agency gtfsId must be formatted properly. Expected #:##, Given ${agency}`)
  }
  return baseId
}

